<?php
ini_set('display_errors', 1);
error_reporting(E_ALL | E_STRICT);
include 'adminpanel/admin/includes/dbconnection.php';
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <?php include './include/head.php'; ?>
    <style>
        .first-con {
            background-color: #D33F4B;
            width: 100%;
            height: 700px;
            background: url('./images/first-con-bg.jpg') 100%, no-repeat;
            background-position: center;
            padding: 0;
        }

        .first-con .overlay-con {
            width: 100%;
            height: 100%;
            background-image: linear-gradient(to bottom, rgba(0, 0, 0, 0), rgba(0, 0, 0, 1));
        }

        .first-con .overlay-con .col-card {
            display: flex;
            justify-content: center;
            align-items: flex-end;
            height: 700px;
            padding: 1rem;
        }

        .overlay1 .col-card {
            display: flex;
            justify-content: center;
            align-items: flex-end;
            padding: 1rem;
        }

        .first-con .overlay-con .col-card .card {
            width: 400px;
        }

        .overlay1 .col-card .card {
            width: 400px;
        }

        .profile-card img {
            width: 300px;
            height: 300px;
            object-fit: cover;

        }

        .profile-name {
            font-size: 16px;
            text-align: center;
        }

        .free-column .card {
            background-color: #fffde0;
        }

        @media (max-width:424px) {
            .first-con {
                height: 500px;
            }

            .first-con .overlay-con .col-card {
                align-items: center;
                height: 500px;
            }

            .first-con .overlay-con .col-card .card {
                align-items: center;
                width: 300px;
            }

            .overlay1 .col-card {
                align-items: center;
                height: 500px;
            }

            .overlay1 .col-card .card {
                align-items: center;
                width: 300px;
            }
        }

        @media (max-width:768px) {
            .first-con .overlay-con .col-card {
                align-items: center;
            }

            .overlay1 .col-card {
                align-items: flex-start;
            }
        }

        #owl-carousel1 .owl-stage,
        #owl-carousel0 .owl-stage {
            padding-top: 5px;
            padding-bottom: 5px;
        }

        #owl-carousel1 .owl-stage .item,
        #owl-carousel0 .owl-stage .item {
            box-shadow: 0px 0px 5px gray;
            border: 1px solid #078603;
        }

        /* Add custom styles for the arrow icons */
        .arrow-icon {
            margin-left: auto;
        }

        /* Rotate the down arrow to indicate open state */
        .btn[aria-expanded="true"] .arrow-icon {
            transform: rotate(180deg);
        }

        .accordion-item a {
            color: black;
            text-decoration: none;
        }

        .accordion-item a:hover {
            color: #078603;
        }

        /* HEAD IMAGE SLIDER */
        #carousel2 img {
            min-height: 500px;
            object-fit: cover;
        }

        #carousel2 .owl-nav button {
            position: absolute;
            top: 50%;
            background-color: #000;
            color: #fff;
            margin: 0;
            transition: all 0.3s ease-in-out;
        }

        #carousel2 .owl-nav button.owl-prev {
            left: 0;
        }

        #carousel2 .owl-nav button.owl-next {
            right: 0;
        }

        #carousel2 .owl-dots {
            text-align: center;
            padding-top: 15px;
        }

        #carousel2 .owl-dots button.owl-dot {
            width: 15px;
            height: 15px;
            border-radius: 50%;
            display: inline-block;
            background: #ccc;
            margin: 0 3px;
        }

        #carousel2 .owl-dots button.owl-dot.active {
            background-color: #000;
        }

        #carousel2 .owl-dots button.owl-dot:focus {
            outline: none;
        }

        #carousel2 .owl-nav button {
            position: absolute;
            top: 50%;
            transform: translateY(-50%);
            background: rgba(255, 255, 255, 0.38) !important;
            display: none;
        }

        #carousel2 span {
            font-size: 70px;
            position: relative;
            top: -5px;
        }

        #carousel2 .owl-nav button:focus {
            outline: none;
        }

        /* overlay1 */
        .owl-slider {
            position: relative;
        }

        .owl-slider .overlay1 {
            position: absolute;
            top: 0;
            z-index: 1;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.3);
            overflow: hidden;
            display: flex;
            align-items: flex-end;
            justify-content: center;
        }

        .owl-slider .overlay1 .container-fluid {
            display: flex;
            align-items: flex-end;
            justify-content: center;
        }
    </style>
</head>



<body>

    <div class="page-wrapper">
        <?php
        include 'include/header.php';
        ?>
        <!-- ---------------------------Carousel BANNER section------------------------ -->
        <div class="container-fluid pt-0 bg-banner-0">
            <div class="">
                <!-- Matchmaking Banner Section Start -->
                <div class="row pt-0">
                    <div class="col-12">
                        <div class="pt-0">
                            <div class="owl-slider">
                                <div id="carousel2" class="owl-carousel">
                                    <div class="item">
                                        <img src="./images/1.jpg" alt="1000X1000">
                                    </div>
                                    <div class="item">
                                        <img src="./images/2.jpg" alt="">
                                    </div>
                                    <div class="item">
                                        <img src="./images/3.jpg" alt="">
                                    </div>
                                    <div class="item">
                                        <img src="./images/4.jpg" alt="">
                                    </div>
                                    <div class="item">
                                        <img src="./images/5.jpg" alt="">
                                    </div>
                                </div>
                                <div class="overlay1">
                                    <div class="container-fluid">
                                        <div class="row w-100">
                                            <div class="col-md-6 d-none d-md-block">
                                                <!-- <img src="./images/logo-no-bg.png" width="300" alt=""> -->
                                            </div>
                                            <div class="col-md-6 col-card">
                                                <div class="card">
                                                    <div class="card-body">
                                                        <form method="POST" action="./registration.php" enctype="multipart/form-data" onsubmit="return check_exist()">
                                                            <h4 class="mb-3">Register</h4>
                                                            <div class="row">

                                                                <div class="col-sm-12">
                                                                    <div class="input-group mb-2">
                                                                        <div class="input-group-prepend" style="width: 100px;">
                                                                            <!-- <input type="text" class="form-control" placeholder="Mr./Mrs./Dr./Miss." required name="title" id="title">   -->
                                                                            <select class="form-control" required name="title" id="title">
                                                                                <option selected value="" disabled>Title</option>
                                                                                <option value="Mr.">Mr.</option>
                                                                                <option value="Mrs.">Mrs.</option>
                                                                                <option value="Ms.">Ms.</option>
                                                                                <option value="Miss.">Miss.</option>
                                                                                <option value="Dr.">Dr.</option>
                                                                            </select>
                                                                        </div>
                                                                        <input type="text" class="form-control" placeholder="Name" name="name" id="name" required="" autocomplete="off">
                                                                    </div>
                                                                </div>

                                                            </div>

                                                            <div class="row">

                                                                <div class="col-sm-12">
                                                                    <div class="input-group mb-2">
                                                                        <input type="email" placeholder="Email ID" name="email" id="email" required="" class="form-control" pattern="[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,4}$" autocomplete="off">
                                                                    </div>
                                                                    <span class="text-danger" id="email_error"></span>
                                                                </div>

                                                            </div>

                                                            <div class="row">

                                                                <div class="col-sm-12">
                                                                    <div class="input-group mb-2">
                                                                        <div class="input-group-prepend" style="width: 100px;">
                                                                            <select name="mobile_code" id="mobile_code" required class="form-control">
                                                                                <option value="" selected disabled>Code</option>
                                                                                <?php
                                                                                $sql = mysqli_query($conn, "SELECT country_code FROM tbl_country");
                                                                                while ($data = mysqli_fetch_assoc($sql)) {
                                                                                    // if ($data['country_code']=="91" || $data['country_code']=="+91" ) {$selected="selected";}else{$selected="";}
                                                                                    echo "<option " . $selected . " value='" . $data['country_code'] . "'>" . $data['country_code'] . "</option>";
                                                                                }
                                                                                ?>
                                                                            </select>
                                                                        </div>
                                                                        <!-- <input type="text" class="form-control " placeholder="Mobile No"  pattern="[0-9]{10}" name="memb_mobile" id="memb_mobile" required=""  autocomplete="off"> -->

                                                                        <input oninput="javascript: if (this.value.length > this.maxLength) this.value = this.value.slice(0, this.maxLength);" type="number" maxlength="10" placeholder="Mobile No" class="form-control" name="memb_mobile" id="memb_mobile" autocomplete="off" />
                                                                    </div>
                                                                    <span class="text-danger" id="mobile_error"></span>
                                                                </div>

                                                            </div>

                                                            <div class="row">

                                                                <div class="col-sm-12">
                                                                    <div class="input-group mb-2">
                                                                        <input type="Password" class="form-control " placeholder="Password" name="password" id="password" required="">
                                                                    </div>
                                                                </div>

                                                            </div>
                                                            <!-- ------------refered by---------------- -->
                                                            <div class="row">

                                                                <div class="col-sm-12">
                                                                    <div class="input-group mb-2">
                                                                        <div class="input-group-prepend" style="width: 38%;">
                                                                            <!-- <input type="text" class="form-control" placeholder="Mr./Mrs./Dr./Miss." required name="title" id="title">   -->
                                                                            <select class="form-control" required name="refered_by" id="refered_by" onchange="get_enabled(this.value)">
                                                                                <option selected value="" disabled>Refered By</option>
                                                                                <option value="Friend">Friend</option>
                                                                                <option value="Relative">Relative</option>
                                                                                <option value="Cold Calling">Cold Calling</option>
                                                                                <option value="Facebook">Facebook</option>
                                                                                <option value="Twitter">Twitter</option>
                                                                                <option value="Instagram">Instagram</option>
                                                                                <option value="Other Social Media">Other Social Media</option>
                                                                                <option value="Website">Website</option>
                                                                                <option value="Walk-In">Walk-In</option>
                                                                                <option value="Flex">Flex</option>
                                                                                <option value="Flayer">Flayer</option>
                                                                                <option value="Newspaper">Newspaper</option>
                                                                                <option value="SMS">SMS</option>
                                                                                <option value="Street Hoardings">Street Hoardings</option>
                                                                                <option value="Event">Event</option>
                                                                                <option value="TV Radio">TV Radio</option>
                                                                            </select>
                                                                        </div>
                                                                        <input type="text" class="form-control" placeholder="Person Name (Mobile Number)" name="refered_by_person" id="refered_by_person" autocomplete="off" readonly>
                                                                    </div>
                                                                </div>

                                                            </div>
                                                            <!-- ------------refered by---------------- -->
                                                            <div class="row pt-3">

                                                                <div class="col-sm-12">
                                                                    <button type="submit" class="thm-btn btn text-light form-control bg-mirza" id="register_btn" name="submit">Register Me</button>
                                                                    <hr>
                                                                    Already Registerd? <a href="member_login" class="text-mirza">Sign-In here.</a>
                                                                </div>

                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid pt-0">
            <div class="container-min" id="about">
                <!--- Why Sanjog Vivah Section Start -->
                <div class="row text-center padding-cont">
                    <div class="col-md-12 col-12 pt-3">
                        <center>
                            <h3 class="font-weight-bold"><span class="text-mirza">WHY SANJOG VIVAH?</span></h3>
                        </center>
                    </div>
                    <!-- <div class="col-md-12 col-12 pt-3 font-great-vibes">
                    Why Sanjog Vivah?
                </div> -->
                    <div class="col-md-8 col-12 mx-auto pt-3 xs-small-text1 box-min-width-text1">
                        Sanjog Vivah, a part of matrimony.com group is a pioneer and leader in online matrimony services for Indians worldwide. We bring over 15 years of expertise in pioneering the Our matchmaking service, and offer the most exclusive database of truly Our matches for you!
                    </div>
                    <div class="col-md-8 col-12 mx-auto pt-3 xs-small-text1 box-min-width-text2">
                        At Sanjog Vivah, we help you find the perfect life partner who matches your stature, aura, and sophistication in every sense of the word.
                    </div>
                    <div class="col-md-9 col-12 mx-auto pt-5 xs-padd5 box-min-width">
                        <div class="row">
                            <div class="col-md-3 col-6 box-width">
                                <div class="service-title-txt">100%</div>
                                <div class="xs-small-text">Confidential</div>
                            </div>
                            <div class="col-md-3 col-6 box-width xs-mt10-min">
                                <div class="service-title-txt">10,000+</div>
                                <div class="xs-small-text">Success Stories</div>
                            </div>
                            <div class="col-md-3 col-6 box-width xs-mt10">
                                <div class="service-title-txt">100+</div>
                                <div class="xs-small-text">Relationship Managers</div>
                            </div>
                            <div class="col-md-3 col-6 box-width xs-mt10">
                                <div class="service-title-txt">15+</div>
                                <div class="xs-small-text">Years of expertise</div>
                            </div>
                        </div>
                    </div>

                </div>
                <!--- Why Sanjog Vivah Section End -->
            </div>
        </div>

        <!-- ---------------------------Carousel BANNER section ENDS------------------------ -->
        <!-- ---------------------------BRING PEAPOLE TOGATHER / CoNTAINER------------------------ -->

        <!-- <div class="container-fluid p-0 py-5 bg-white">
            <div class="container index-container mb-4">
                <center>
                    <h6 class="text-uppercase">Books The There</h6>
                    <h3 class="font-weight-bold"><span class="text-mirza">LENORE MEMORIES BUST</h3>
                    <p>Lenore form there stopped a books the there. Memories usby bust truly till floor tossed a, on bust said still ah evilprophet name kind still, horror distant my grim bird,.</p>
                </center>
                <br>
                <div class="row">
                    <div class="col-md-6 d-md-none">
                        <img src="./images/2.jpg" class="w-100" alt="">
                    </div>
                    <div class="col-md-6 pt-2 pt-md-0">
                        <h3 class="font-weight-bold">Amet magna sadipscing rebum lorem labore. Ipsum gubergren vero sed rebum invidunt.</h3>
                        <span>
                            You can input information about location, gotra, cast, etc. to find relevant profiles, and the upgraded artificial intelligence will utilise this information to sort the profiles in accordance with the needs.
                        </span>
                    </div>
                    <div class="col-md-6 d-none d-md-inline">
                        <img src="./images/2.jpg" class="w-100" alt="">
                    </div>
                </div>
            </div>

            <div class="container index-container">
                <div class="row">
                    <div class="col-md-6">
                        <img src="./images/3.jpg" class="w-100" alt="">
                    </div>
                    <div class="col-md-6 pt-2 pt-md-0">
                        <h3 class="font-weight-bold">Amet magna sadipscing rebum lorem labore. Ipsum gubergren vero sed rebum invidunt.</h3>
                        <span>
                            You can input information about location, gotra, cast, etc. to find relevant profiles, and the upgraded artificial intelligence will utilise this information to sort the profiles in accordance with the needs.
                        </span>
                    </div>
                </div>
            </div>
        </div> -->

        <div class="container-fluid p-0 py-5 bg-gray">

            <div class="container index-container mb-5">
                <center>
                    <h6 class="text-uppercase">Our Members</h6>
                    <h3 class="font-weight-bold"><span class="text-mirza">PROFILES OF OUR MEMBERS</h3>
                    <p>Lenore form there stopped a books the there. Memories usby bust truly till floor tossed a, on bust said still ah evilprophet name kind still, horror distant my grim bird,.</p>
                </center>
                <br>
                <h4 class="font-weight-bold"><span class="text-mirza">GROOM</span></h4>
                <span>Accusam et dolore sadipscing duo consetetur et. Labore ut nonumy stet dolor sed, et ea et eos labore dolores eirmod.</span>
                <div id="owl-carousel1" class="owl-carousel owl-theme mt-3">
                    <?php
                    $sql = "SELECT tbl_registration.*,tbl_state.state_name,tbl_religion.religion_name,tbl_caste.caste_name,tbl_country.country_name FROM tbl_registration 
                    LEFT JOIN tbl_state ON tbl_registration.state=tbl_state.state_id
                    LEFT JOIN tbl_religion ON tbl_registration.religion=tbl_religion.religion_id
                    LEFT JOIN tbl_caste ON tbl_registration.caste=tbl_caste.caste_id
                    LEFT JOIN tbl_country ON tbl_registration.country=tbl_country.country_id
                    WHERE tbl_registration.gender='male' AND tbl_registration.title='Mr.' AND tbl_registration.pro_main_img!='' ORDER BY RAND() LIMIT 10";
                    $reponse = $conn->query($sql);
                    if ($reponse) {
                        // print_r($reponse);
                        if ($reponse->num_rows > 0) {
                            foreach ($reponse as $user) {
                    ?>
                                <div class="item">
                                    <div class="card">
                                        <div class="card-body profile-card p-2 text-center">
                                            <img src="./member_fold/<?php echo $user['pro_main_img'] ?>" alt="Profile Image">
                                            <span class="profile-name">
                                                <b>ID : <?php echo $user['memb_unique_id'] ?></b>
                                                <p class="m-0">
                                                    <?php echo $user['religion_name'] ?>
                                                    |
                                                    <?php echo $user['caste_name'] ?>
                                                    |
                                                    <?php echo $user['state_name'] ?>
                                                    |
                                                    <?php echo $user['country_name'] ?>
                                                </p>
                                            </span>
                                        </div>
                                    </div>

                                </div>
                            <?php
                            }
                        } else {
                            ?>
                            <div class="item">
                                <div class="card">
                                    <div class="card-body profile-card p-2 text-center">
                                        <img src="./images/logo-bg.jpg" alt="Profile Image">
                                        <span class="profile-name">
                                            Mr. Dummy Account
                                        </span>
                                    </div>
                                </div>

                            </div>
                    <?php
                        }
                    }
                    ?>
                </div>
            </div>
            <div class="container index-container">
                <h4 class="font-weight-bold"><span class="text-mirza">BRIDE</span></h4>
                <span>Accusam et dolore sadipscing duo consetetur et. Labore ut nonumy stet dolor sed, et ea et eos labore dolores eirmod.</span>
                <div id="owl-carousel0" class="owl-carousel owl-theme mt-3">
                    <?php
                    $sql = "SELECT tbl_registration.*,tbl_state.state_name,tbl_religion.religion_name,tbl_caste.caste_name,tbl_country.country_name FROM tbl_registration 
                    LEFT JOIN tbl_state ON tbl_registration.state=tbl_state.state_id
                    LEFT JOIN tbl_religion ON tbl_registration.religion=tbl_religion.religion_id
                    LEFT JOIN tbl_caste ON tbl_registration.caste=tbl_caste.caste_id
                    LEFT JOIN tbl_country ON tbl_registration.country=tbl_country.country_id
                    WHERE gender='female' AND title='Miss.' AND pro_main_img!='' ORDER BY RAND() LIMIT 10";
                    $reponse = $conn->query($sql);
                    if ($reponse) {
                        // print_r($reponse);
                        if ($reponse->num_rows > 0) {
                            foreach ($reponse as $user) {
                    ?>
                                <div class="item">
                                    <div class="card">
                                        <div class="card-body profile-card p-2 text-center">
                                            <img src="./member_fold/<?php echo $user['pro_main_img'] ?>" alt="Profile Image">
                                            <span class="profile-name">
                                                <b>ID : <?php echo $user['memb_unique_id'] ?></b>
                                                <p class="m-0">
                                                    <?php echo $user['religion_name'] ?>
                                                    |
                                                    <?php echo $user['caste_name'] ?>
                                                    |
                                                    <?php echo $user['state_name'] ?>
                                                    |
                                                    <?php echo $user['country_name'] ?>
                                                </p>
                                            </span>
                                        </div>
                                    </div>

                                </div>
                            <?php
                            }
                        } else {
                            ?>
                            <div class="item">
                                <div class="card">
                                    <div class="card-body profile-card p-2 text-center">
                                        <img src="./images/logo-bg.jpg" alt="Profile Image">
                                        <span class="profile-name">
                                            Miss. Dummy Account
                                        </span>
                                    </div>
                                </div>

                            </div>
                    <?php
                        }
                    }
                    ?>
                </div>
            </div>
        </div>

        <div class="container-fluid p-0 py-5 bg-white">
            <div class="container">
                <!--- How it works? Section Start -->
                <div class="row text-center">
                    <div class="col-md-12 col-12 pt-3">
                        <center>
                            <h3 class="font-weight-bold"><span class="text-mirza">HOW IT WORKS?</span></h3>
                        </center>
                    </div>
                    <!-- <div class="col-md-12 col-12 pt-3 font-great-vibes">
                        How it works?
                    </div> -->
                    <div class="col-md-11 col-12 mx-auto pt-3">
                        <div class="row mt-4">

                            <div class="swiper-container pointer-events-none">
                                <div class="swiper-wrapper">

                                    <div class="col-md-4 col-12 text-left swiper-slide card-width">
                                        <div class="text-center"><img src="images/card-img-1.jpg" alt="Image"></div>
                                        <div class="card-width-text">
                                            <div class="font-weight-bold">Personal Relationship Manager</div>
                                            <div class="mt-2 xs-small-text1 xs-mt10">Connect with the profile manager, a highly skilled advisor to manage your profile.</div>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-12 text-left swiper-slide card-width">
                                        <div class="text-center"><img src="images/card-img-2.jpg" alt="Image"></div>
                                        <div class="card-width-text">
                                            <div class="font-weight-bold">Share your preferences with others</div>
                                            <div class="mt-2 xs-small-text1 xs-mt10">Consultation to determine what qualities you seek in a potential spouse.</div>
                                        </div>
                                    </div>
                                    <div class="col-md-4 col-12 text-left swiper-slide card-width">
                                        <div class="text-center"><img src="images/card-img-3.jpg" alt="Image"></div>
                                        <div class="card-width-text">
                                            <div class="font-weight-bold">Choose from a wide range of profiles</div>
                                            <div class="mt-2 xs-small-text1 xs-mt10">We narrow down profiles that meet your requirements for offline interactions.</div>
                                        </div>
                                    </div>

                                </div>
                            </div>


                        </div>
                    </div>
                    <div class="col-md-12 col-12 pt-3 xs-pad0">
                        <a href="./contact" rel="noreferrer"><button type="submit" class="btn btn-service xs-mt10">Interested in Our service?</button></a>
                    </div>
                </div>
                <!--- How it works Section End -->
            </div>
        </div>

        <div class="container-fluid p-0 py-5">
            <div class="container index-container">
                <div class="card bg-light border-0 index-card">
                    <div class="card-header text-center" style="border-bottom: none;background: transparent;">
                        <h6 class="text-uppercase">Upgrade Your Account</h6>
                        <h3 class="font-weight-bold"><span class="text-mirza">PACKAGES</h3>
                        <p>Upgrade your package in accordance with your specific needs. You can easily interact with your prospects and receive more responses if you have a paid membership. Here are several major advantages</p>
                    </div>
                    <div class="card-body">
                        <div class="row justify-content-center ">

                            <div class="col-sm-4 p-0 m-md-0 mb-5 free-column">
                                <div class="card">
                                    <div class="card-header text-uppercase h5 font-weight-bold" style="border-bottom: none;background: transparent;">Free</div>
                                    <div class="card-body">
                                        <table class="table mb-0">
                                            <tr>
                                                <th style="width:10px;"><i class="fa fa-check text-mirza"></i></th>
                                                <td>Browse Profiles</td>
                                            </tr>
                                            <tr>
                                                <th style="width:10px;"><i class="fa fa-check text-mirza"></i></th>
                                                <td>Send Interest</td>
                                            </tr>
                                            <tr>
                                                <th style="width:10px;"><i class="fa fa-check text-mirza"></i></th>
                                                <td>Unlimited Message</td>
                                            </tr>
                                            <tr class="">
                                                <th style="width:10px;"><i class="fa fa-check text-mirza"></i></th>
                                                <td>Preference Result</td>
                                            </tr>
                                            <tr class="">
                                                <th style="width:10px;"><i class="fa fa-check text-mirza"></i></th>
                                                <td>Advance Search</td>
                                            </tr>

                                            <tr class="">
                                                <th style="width:10px;"><i class="fa fa-check text-mirza"></i></th>
                                                <td>Upload Photograph Request</td>
                                            </tr>
                                            <tr class="">
                                                <th style="width:10px;"><i class="fa fa-check text-mirza"></i></th>
                                                <td>Unlimited Like & Dislike</td>
                                            </tr>

                                            <tr class="">
                                                <td colspan="2"><a href="registration" class="btn text-light btn-default w-100 font-weight-bold bg-mirza" style="letter-spacing: 2px;font-size: 18px;">Register Free</a></td>

                                            </tr>

                                        </table>
                                    </div>
                                </div>
                            </div>


                            <div class="col-sm-4 p-0 m-0 paid-column" style="">
                                <div class="card bg-mirza paid-card" style="box-shadow: 0px 0px 10px 0px #078603;padding: 15px 0px 20px 18px; z-index: 33;margin-top: -28px;">
                                    <div class="card-header text-uppercase h5 font-weight-bold" style="border-bottom: none;background: transparent; ;">Paid</div>
                                    <div class="card-body">
                                        <table class="table mb-0 text-white">
                                            <tr>
                                                <th style="width:10px;"><i class="fa fa-check"></i></th>
                                                <td>Browse Profiles</td>
                                            </tr>
                                            <tr>
                                                <th style="width:10px;"><i class="fa fa-check"></i></th>
                                                <td>Send Interest</td>
                                            </tr>
                                            <tr>
                                                <th style="width:10px;"><i class="fa fa-check"></i></th>
                                                <td>Unlimited Message</td>
                                            </tr>
                                            <tr>
                                                <th style="width:10px;"><i class="fa fa-check"></i></th>
                                                <td>Preference Result</td>
                                            </tr>
                                            <tr>
                                                <th style="width:10px;"><i class="fa fa-check"></i></th>
                                                <td>Advance Search</td>
                                            </tr>
                                            <tr>
                                                <th style="width:10px;"><i class="fa fa-check"></i></th>
                                                <td>Upload Photograph Request</td>
                                            </tr>

                                            <tr>
                                                <th style="width:10px;"><i class="fa fa-check"></i></th>
                                                <td>Unlimited Like & Dislike</td>
                                            </tr>

                                            <tr>
                                                <th style="width:10px;"><i class="fa fa-check"></i></th>
                                                <td>Unlimited Contacts</td>
                                            </tr>
                                            <tr>
                                                <td colspan="2"><a href="packages" class="btn  btn-light bg-white w-100 font-weight-bold  text-dark" style="letter-spacing: 2px;font-size: 18px;">Browse Membership Plan</a></td>

                                            </tr>

                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="container-fluid p-0 py-md-5 py-3 bg-gray">
            <div class="container index-container p-0">
                <center>
                    <h6 class="text-uppercase">Browse By Filters</h6>
                    <h3 class="font-weight-bold"><span class="text-mirza">PROFILES BY :</span></h3>
                </center>
                <div id="accordion">
                    <div class="card">
                        <div class="card-header accordion-button" id="headingOne" type="button" data-toggle="collapse" data-target="#collapseOne">
                            <div class="d-flex justify-content-between align-items-center w-100">
                                <span class="text-mirza">Mother Tongue</span>
                                <button class="btn bg-mirza text-light" data-toggle="collapse" data-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                    <i class="arrow-icon fas fa-chevron-down"></i>
                                </button>
                            </div>
                        </div>

                        <div id="collapseOne" class="collapse accordion-item show" aria-labelledby="headingOne" data-parent="#accordion">
                            <div class="card-body">
                                <?php
                                $sql_mothertongue = mysqli_query($conn, "SELECT * FROM tbl_lang AS t1 INNER JOIN (SELECT lang_id,lang_name FROM tbl_lang ORDER BY RAND() LIMIT 50) as t2 ON t1.lang_id=t2.lang_id ORDER BY t1.lang_name ASC");
                                if (mysqli_num_rows($sql_mothertongue) > 0) {
                                    while ($mt = mysqli_fetch_assoc($sql_mothertongue)) {
                                        echo "<a href='lang_filter.php?lang=" . $mt['lang_id'] . "'  accordion-button>" . $mt['lang_name'] . " | </a>";
                                    }
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header accordion-button" id="headingTwo" type="button" data-toggle="collapse" data-target="#collapseTwo">
                            <div class="d-flex justify-content-between align-items-center w-100">
                                <span class="text-mirza">Religion</span>
                                <button class="btn bg-mirza text-light" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="true" aria-controls="collapseOne">
                                    <i class="arrow-icon fas fa-chevron-down"></i>
                                </button>
                            </div>
                        </div>

                        <div id="collapseTwo" class="collapse accordion-item" aria-labelledby="headingTwo" data-parent="#accordion">
                            <div class="card-body">
                                <?php
                                $sql_religionwise = mysqli_query($conn, "SELECT * FROM tbl_religion AS t1 INNER JOIN (SELECT religion_id,religion_name FROM tbl_religion ORDER BY RAND() LIMIT 50) as t2 ON t1.religion_id=t2.religion_id ORDER BY t1.religion_name ASC");
                                if (mysqli_num_rows($sql_religionwise) > 0) {
                                    while ($rel = mysqli_fetch_assoc($sql_religionwise)) {
                                        echo "<a href='religion_filter.php?rel=" . $rel['religion_id'] . "'  accordion-button>" . $rel['religion_name'] . " | </a>";
                                    }
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header accordion-button" id="headingThree" type="button" data-toggle="collapse" data-target="#collapseThree">
                            <div class="d-flex justify-content-between align-items-center w-100">
                                <span class="text-mirza">State</span>
                                <button class="btn btn bg-mirza text-light" data-toggle="collapse" data-target="#collapseThree" aria-expanded="true" aria-controls="collapseOne">
                                    <i class="arrow-icon fas fa-chevron-down"></i>
                                </button>
                            </div>
                        </div>

                        <div id="collapseThree" class="collapse accordion-item" aria-labelledby="headingThree" data-parent="#accordion">
                            <div class="card-body">
                                <?php
                                $sql_statewise = mysqli_query($conn, "SELECT * FROM tbl_state AS t1 INNER JOIN (SELECT state_id,state_name FROM tbl_state ORDER BY RAND() LIMIT 50) as t2 ON t1.state_id=t2.state_id ORDER BY t1.state_name ASC");
                                if (mysqli_num_rows($sql_statewise) > 0) {
                                    while ($stt = mysqli_fetch_assoc($sql_statewise)) {
                                        echo "<a href='state_filter.php?stt=" . $stt['state_id'] . "'  accordion-button>" . $stt['state_name'] . " | </a>";
                                    }
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header accordion-button" id="headingFour" type="button" data-toggle="collapse" data-target="#collapseFour">
                            <div class="d-flex justify-content-between align-items-center w-100">
                                <span class="text-mirza">City</span>
                                <button class="btn btn bg-mirza text-light" data-toggle="collapse" data-target="#collapseFour" aria-expanded="true" aria-controls="collapseOne">
                                    <i class="arrow-icon fas fa-chevron-down"></i>
                                </button>
                            </div>
                        </div>

                        <div id="collapseFour" class="collapse accordion-item" aria-labelledby="headingFour" data-parent="#accordion">
                            <div class="card-body">
                                <?php
                                $sql_citywise = mysqli_query($conn, "SELECT * FROM tbl_city AS t1 INNER JOIN (SELECT city_id,city_name FROM tbl_city ORDER BY RAND() LIMIT 50) as t2 ON t1.city_id=t2.city_id ORDER BY t1.city_name ASC");
                                if (mysqli_num_rows($sql_citywise) > 0) {
                                    while ($ct = mysqli_fetch_assoc($sql_citywise)) {
                                        echo "<a href='city_filter.php?ct=" . $ct['city_id'] . "'  accordion-button>" . $ct['city_name'] . " | </a>";
                                    }
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-header accordion-button" id="headingfive" type="button" data-toggle="collapse" data-target="#collapsefive">
                            <div class="d-flex justify-content-between align-items-center w-100">
                                <span class="text-mirza">Occupation</span>
                                <button class="btn bg-mirza text-light" data-toggle="collapse" data-target="#collapsefive" aria-expanded="true" aria-controls="collapseOne">
                                    <i class="arrow-icon fas fa-chevron-down"></i>
                                </button>
                            </div>
                        </div>

                        <div id="collapsefive" class="collapse accordion-item" aria-labelledby="headingfive" data-parent="#accordion">
                            <div class="card-body">
                                <?php
                                $sql_occuwise = mysqli_query($conn, "SELECT * FROM tbl_occupation AS t1 INNER JOIN (SELECT oc_id,oc_name FROM tbl_occupation ORDER BY RAND() LIMIT 50) as t2 ON t1.oc_id=t2.oc_id ORDER BY t1.oc_name ASC ");
                                if (mysqli_num_rows($sql_occuwise) > 0) {
                                    while ($oc = mysqli_fetch_assoc($sql_occuwise)) {
                                        echo "<a href='occu_filter.php?oc=" . $oc['oc_id'] . "'  accordion-button>" . $oc['oc_name'] . " | </a>";
                                    }
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- <div class="accordion" id="myAccordion">
                    <div class="card">
                        <div class="card-header" id="headingOne">
                            <h2 class="mb-0">
                                <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#collapseOne">
                                    Accordion Title 1
                                    <i class="arrow-icon fas fa-chevron-down"></i> 
                                </button>
                            </h2>
                        </div>
                        <div id="collapseOne" class="collapse" data-parent="#myAccordion">
                            <div class="card-body">
                                Content for Accordion Item 1.
                            </div>
                        </div>
                    </div>
                </div> -->

            </div>
        </div>
        <div class="container-fluid p-0 py-md-5 py-3 d-none bg-gray">
            <div class="container index-container p-0">
                <div class="card  p-3 pl-md-5 border-0 index-card">
                    <div class="card-header text-center" style="border-bottom: none;background: transparent;">
                        <h6 class="text-uppercase">Browse By Filters</h6>
                        <h3 class="font-weight-bold"><span class="text-mirza">PROFILES BY :</span></h3>
                    </div>
                    <div class="card-body p-0">


                        <ul class="nav nav-tabs nav-justified">
                            <li class="nav-item">
                                <a class="nav-link text-mirza active" data-toggle="tab" href="#mother_tongue">Mother Tongue</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link text-mirza " data-toggle="tab" href="#religionwise">Religion</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link text-mirza" data-toggle="tab" href="#statewise">State</a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link text-mirza" data-toggle="tab" href="#citywise">City</a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link text-mirza" data-toggle="tab" href="#occuwise">Occupation</a>
                            </li>




                        </ul>
                        <div class="tab-content">
                            <div class="container-fluid drivers-main tab-pane active" id="mother_tongue" role="tabpanel">
                                <p style="font-family:timesnewroman;">
                                    <?php
                                    $sql_mothertongue = mysqli_query($conn, "SELECT * FROM tbl_lang AS t1 INNER JOIN (SELECT lang_id,lang_name FROM tbl_lang ORDER BY RAND() LIMIT 50) as t2 ON t1.lang_id=t2.lang_id ORDER BY t1.lang_name ASC");
                                    if (mysqli_num_rows($sql_mothertongue) > 0) {
                                        while ($mt = mysqli_fetch_assoc($sql_mothertongue)) {
                                            echo "<a href='lang_filter.php?lang=" . $mt['lang_id'] . "'  class='text-dark'>" . $mt['lang_name'] . " | </a>";
                                        }
                                    }
                                    ?>
                                </p>
                            </div>

                            <div class="container-fluid drivers-main tab-pane" id="religionwise" role="tabpanel">
                                <p style="font-family:timesnewroman;">
                                    <?php
                                    $sql_religionwise = mysqli_query($conn, "SELECT * FROM tbl_religion AS t1 INNER JOIN (SELECT religion_id,religion_name FROM tbl_religion ORDER BY RAND() LIMIT 50) as t2 ON t1.religion_id=t2.religion_id ORDER BY t1.religion_name ASC");
                                    if (mysqli_num_rows($sql_religionwise) > 0) {
                                        while ($rel = mysqli_fetch_assoc($sql_religionwise)) {
                                            echo "<a href='religion_filter.php?rel=" . $rel['religion_id'] . "'  class='text-dark'>" . $rel['religion_name'] . " | </a>";
                                        }
                                    }
                                    ?>
                                </p>
                            </div>
                            <div class="container-fluid drivers-main tab-pane" id="statewise" role="tabpanel">
                                <p style="font-family:timesnewroman;">
                                    <?php
                                    $sql_statewise = mysqli_query($conn, "SELECT * FROM tbl_state AS t1 INNER JOIN (SELECT state_id,state_name FROM tbl_state ORDER BY RAND() LIMIT 50) as t2 ON t1.state_id=t2.state_id ORDER BY t1.state_name ASC");
                                    if (mysqli_num_rows($sql_statewise) > 0) {
                                        while ($stt = mysqli_fetch_assoc($sql_statewise)) {
                                            echo "<a href='state_filter.php?stt=" . $stt['state_id'] . "'  class='text-dark'>" . $stt['state_name'] . " | </a>";
                                        }
                                    }
                                    ?>
                                </p>
                            </div>



                            <div class="container-fluid drivers-main tab-pane" id="citywise" role="tabpanel">
                                <p style="font-family:timesnewroman;">
                                    <?php
                                    $sql_citywise = mysqli_query($conn, "SELECT * FROM tbl_city AS t1 INNER JOIN (SELECT city_id,city_name FROM tbl_city ORDER BY RAND() LIMIT 50) as t2 ON t1.city_id=t2.city_id ORDER BY t1.city_name ASC");
                                    if (mysqli_num_rows($sql_citywise) > 0) {
                                        while ($ct = mysqli_fetch_assoc($sql_citywise)) {
                                            echo "<a href='city_filter.php?ct=" . $ct['city_id'] . "'  class='text-dark'>" . $ct['city_name'] . " | </a>";
                                        }
                                    }
                                    ?>
                                </p>
                            </div>

                            <div class="container-fluid drivers-main tab-pane" id="occuwise" role="tabpanel">
                                <p style="font-family:timesnewroman;">
                                    <?php
                                    $sql_occuwise = mysqli_query($conn, "SELECT * FROM tbl_occupation AS t1 INNER JOIN (SELECT oc_id,oc_name FROM tbl_occupation ORDER BY RAND() LIMIT 50) as t2 ON t1.oc_id=t2.oc_id ORDER BY t1.oc_name ASC ");
                                    if (mysqli_num_rows($sql_occuwise) > 0) {
                                        while ($oc = mysqli_fetch_assoc($sql_occuwise)) {
                                            echo "<a href='occu_filter.php?oc=" . $oc['oc_id'] . "'  class='text-dark'>" . $oc['oc_name'] . " | </a>";
                                        }
                                    }
                                    ?>
                                </p>
                            </div>





                        </div>


                    </div>
                </div>
            </div>
        </div>
        <!-- ---------------------------BRING PEAPOLE TOGATHER / CoNTAINER ENDS------------------------ -->
        <!-- ---------------------------Browse Profile By Starts------------------------ -->

        <!-- ---------------------------Browse Profile By ENDS------------------------ -->
        <?php include 'include/footer.php'; ?>
        <script src="js/swiper-bundle.min.js"></script>
        <script>
            function check_exist() {
                var email = $("#email").val();
                var phone = $("#memb_mobile").val();
                if (email != "") {
                    var xmlhttp = new XMLHttpRequest();
                    xmlhttp.open("GET", "include/check_exist.php?email=" + email, false);
                    xmlhttp.send(null);
                    if (xmlhttp.responseText == "1") {
                        document.getElementById('email_error').innerHTML = "Mail already exist, Try new!";
                        return false;
                    } else {
                        document.getElementById('email_error').innerHTML = "";

                    }
                }
                if (phone != "") {
                    var xmlhttp = new XMLHttpRequest();
                    xmlhttp.open("GET", "include/check_exist.php?phone=" + phone, false);
                    xmlhttp.send(null);
                    // alert(xmlhttp.responseText);
                    if (xmlhttp.responseText == "1") {
                        document.getElementById('mobile_error').innerHTML = "Mobile Number already exist, Try new!";
                        return false;
                    } else {
                        document.getElementById('mobile_error').innerHTML = "";

                    }
                }



            }

            // ===================refered by========================
            function get_enabled(soc) {
                // alert(soc);
                if (soc == "Friend" || soc == "Relative") {
                    document.getElementById("refered_by_person").removeAttribute('readonly');
                } else {
                    document.getElementById("refered_by_person").readOnly = true;
                }
            }

            $(document).ready(function() {
                jQuery("#carousel2").owlCarousel({
                    animateOut: 'fadeOut',
                    autoplay: true,
                    //   rewind: true, /* use rewind if you don't want loop */
                    margin: 20,
                    responsiveClass: true,
                    autoHeight: true,
                    autoplayTimeout: 7000,
                    loop: true,
                    autoPlay: true,
                    rewindNav: false,
                    smartSpeed: 800,
                    lazyLoad: true,
                    nav: true,
                    dots: false,
                    responsive: {
                        0: {
                            items: 1,
                            loop: true
                        },
                    }
                });

                $('#owl-carousel0,#owl-carousel1').owlCarousel({
                    loop: true,
                    autoplay: true,
                    autoplayTimeout: 3000,
                    autoplayHoverPause: true,
                    margin: 10,
                    nav: false,
                    dots: false,
                    responsive: {
                        0: {
                            items: 1
                        },
                        600: {
                            items: 3
                        },
                        1000: {
                            items: 4
                        }
                    }
                });
            });

            $('.accordion-button').on('click', function() {
                // Close all panels
                $('.accordion-panel').collapse('hide');

                // Open the clicked panel
                $($(this).data('target')).collapse('show');
            });
        </script>
        <script>
            var swiper = new Swiper('.pointer-events-none', {
                slidesPerView: 'auto',

                centeredSlides: false,
                spaceBetween: 10,
                grabCursor: true,
                pagination: {
                    el: '.swiper-pagination',
                    clickable: true,
                },


            });
        </script>
    </div>

</body>

</html>